<?php

// classes
class InSim
{
	var $dbProperties = "plugin state LFSConnection LFSversion player connect layout result";
	var $state;
	var $LFSConnection;
	var $LFSVersion;
	var $player;
	var $connect;
	var $layout;
	var $result;

	var $plugin = array();
}

class Plugin extends InSim
{
	var $conn;
	var $author = "";
	var $title = "";
	var $ver = "";
	
	function __construct(&$conn)
	{
		if (!is_object($conn))
			return false;
		
		if (get_class($conn) !== "Connection")
			return false;
		
		$this->conn =& $conn;
		
		$names = explode(" ", $conn->dbProperties);
		
		foreach($names as $v)
			$this->$v =& $conn->$v;
	}
}

class Connection extends InSim
{
	var $connIn;
	var $connOut;
	var $debugIn = false;
	var $debugOut = false;

	var $delayed = array();

	function __construct(&$connIn, &$connOut, $pluginName = array(), $debugIn = false, $debugOut = false)
	{
		
		if (!is_array($pluginName))
			return false;
		
		$this->connIn   =& $connIn;
		$this->connOut  =& $connOut;

		$this->debugIn  =  $debugIn;
		$this->debugOut =  $debugOut;
		
		foreach($pluginName as $v)
			$this->regPlugin($v);
	}
	
	function connect($data)
	{
		$data["Type"] = ISP_ISI;
		$this->sendPacket(compPacket($data));
	}
	
	function regPlugin($className)
	{
		if (!class_exists($className))
			return false;
			
		if (!is_subclass_of("{$className}", "Plugin"))
			return false;
		
		$this->plugin[$className] = new $className($this);

		return true;
	}
	
	function callFunc($funcName, $data)
	{
		reset($this->plugin);
		while (list($k,) = each($this->plugin))
			if(method_exists($this->plugin[$k], $funcName))
				$this->plugin[$k]->$funcName($data);
	}
	
	function sendPacket($pack, $time = 0, $flush = true)
	{
		/*
		Sends binary $pack to $socket or schedules it to be sent after $time comes. If $flush is set to true, it first calls scheduleSend to send the already scheduled packets. ($flush parameter is needed first of all to avoid a loop, since scheduleSend uses this very function to send it's packets.
		*/
		if ($flush === true)
			$this->sendDelayed();
			
		// if the time hasn't come, it adds the packet to the schedule.
		if (time() < $time)
			array_push($this->delayed, array($pack, $time));

		else
		{
			if ($this->debugOut === true)
			{
				writeRoutine("outtext.log", var_export(decompPacket($pack), true));
				writeRoutine("outraw.log", bin2hex($pack));
			}
			
			socket_write($this->connOut, $pack, strlen($pack));
		}
	}
	
	function sendDelayed()
	{
		/*	
		Walks through the $SCHEDULE and sends the packets that already have to be sent.
		*/
		reset($this->delayed);
			
		foreach($this->delayed as $k => $v)
		if (time() > $v[1])
		{
			socket_write($this->connOut, $v[0], strlen($v[0]));
			unset($this->delayed[$k]);
		}
	}
	
	function receivePacket()
	{
		/*
		Opens the socket for incoming packets and reads from it.
		
		BTW, can't use socket_listen here for UDP. socket_read makes the script run infinitely until some data arrives to the port, even set_time_limit has no effect on this (in WinXP).
		*/
		$pack = socket_read($this->connIn, 256, PHP_BINARY_READ);
		
		if ($this->debugIn === true)
		{
			writeRoutine("intext.log", var_export(decompPacket($pack), true));
			writeRoutine("inraw.log", bin2hex($pack));
		}
	
		return decompPacket($pack);
	}
}

